function Swr = user_ExtForces(PxF,RxF,VxF,OMxF,AxF,OMPxF,mbs_data,tsim,ixF)
% --------------------------
% UCL-CEREM-MBS
%
% @version MBsysLab_m 1.7.a
%
% Creation : 2006
% Last update : 30/09/2008
% -------------------------
%
%Swr = user_ExtForces(PxF,RxF,VxF,OMxF,AxF,OMPxF,mbs_data,tsim,ixF)
%
% PxF(3,1) : absolute position vector of the external force application point 
% RxF(3,3) : absolute rotation matrix of the body
% VxF(3,1) : absolute velocity vector of the external force application point 
% OMxF(3,1) : absolute angular velocity vector of the body
% AxF(3,1) : absolute acceleration vector of the external force application point 
% OMPxF(3,1) : absolute angular acceleration vector of the body
%
% => All above vectors are expressed in the inertial reference frame !
%
% mbs_data : multibody data structure
% tsim : current time
% ixF : index of the external force sensor ('F' type in MBsysPad)
%        (can be obtained via the 'mbs_get_F_sensor_id' function)
%
% Swr(9,1) = [Fx; Fy; Fz; Mx; My; Mz; dxF];
%   - Force components (expressed in the inertial frame) : Fx, Fy, Fz
%   - Pure torque components (expressed in the inertial frame) : Mx, My, Mz
%   - Application point local coordinates vector (expressed in the body-fixed frame) : dxF(1:3,1);
%
% this function may use a global structure called MBS_user

global MBS_user MBS_info

Fx=0.0; Fy=0.0; Fz=0.0;
Mx=0.0; My=0.0; Mz=0.0;
idpt = mbs_data.xfidpt(ixF);
dxF = mbs_data.dpt(:,idpt);

%/*-- Begin of user code --*/
% 
% Use the 'mbs_get_F_sensor_id' function to get easily the force sensor
% indices, e.g. :
% F1 = mbs_get_F_sensor_id(MBS_info,'myFsensor_1');
% [F2,F3] = mbs_get_F_sensor_id(MBS_info,'myFsensor_2','myFsensor_3');
%

Fwheel_id = mbs_get_F_sensor_id(MBS_info,'Force_Wheel');
switch(ixF)
    case Fwheel_id
        [rz, angcamb, anglis, gliss, Pct, Vct,Zgnd, Rsol, dxF] = mbs_kine_wheel(PxF,RxF,VxF,OMxF,mbs_data,tsim);

        %   Tyre characteristics
        rnom = mbs_data.user_model.WHEEL.rnom;
        K = mbs_data.user_model.WHEEL.K;

%         %   Absolute roll angle : between wheel axis unit vector
%         %   and its normed ground projection
%         ey = [RxF(2,1); RxF(2,2); RxF(2,3)];
%         eyP = [RxF(2,1); RxF(2,2); 0];
%         eyP = eyP/norm(eyP);
%         cosphi = ey'*eyP;
% 
%         %   Nominal radius : ground perpendicular component
%         rnomP = rnom*cosphi;
% 
%         %   Normal ground penetration - normal force
%         e = rnomP - (PxF(3)-sol); % on retranche de rnomP la hauteur pr. au sol

        e = (rnom-rz)*cos(angcamb);
        if strcmp(MBS_user.process,'Equil')
            Fz = K*e;
        else
            if e > 0
                Fz = K*e;
            else
                Fz = 0;
            end
        end

        MBS_user.curvar.FWheel=Fz;

%         % moment vector dxF = OP (O = wheel center ; P = contact point)
%         ex = cross(eyP, [0;0;1]);       % unit tangent circounferential vector
%         ep = cross(ex,ey);              % unit vector direction PO
%         dxFIn = -(PxF(3)/cosphi)*ep;    % OP vector (inertial frame)
%         dxF = RxF*dxFIn;                % OP vector (wheel frame)

        xFIn = PxF' + RxF'*dxF;
        MBS_user.curvar.extForce1(1:6)=[0 0 Fz 0 0 0];
        MBS_user.curvar.extForce1(7:9)=xFIn';
        MBS_user.curvar.extForce1(10:18)=[Rsol(1,:) Rsol(2,:) Rsol(3,:)];
        
        MBS_user.curvar.extForces(ixF).P = Pct;
        MBS_user.curvar.extForces(ixF).R = Rsol;
        MBS_user.curvar.extForces(ixF).F = [0 0 Fz];

end

%/*-- End of user code --*/

%extForces storage for animation
% position of the force in the inertial frame
MBS_user.curvar.extForces(ixF).P = (PxF'+RxF'*dxF)';
% rotation matrix between inertal and user frame (default: no rotation)
MBS_user.curvar.extForces(ixF).R = [1 0 0; 0 1 0; 0 0 1];
% Force components in the user frame (default: in the inertial frame)
MBS_user.curvar.extForces(ixF).F = [Fx Fy Fz];


Swr = [Fx; Fy; Fz; Mx; My; Mz; dxF];

return